// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Spot allocation strategy types for Compute Fleet. </summary>
    public readonly partial struct SpotAllocationStrategy : IEquatable<SpotAllocationStrategy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SpotAllocationStrategy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SpotAllocationStrategy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PriceCapacityOptimizedValue = "PriceCapacityOptimized";
        private const string LowestPriceValue = "LowestPrice";
        private const string CapacityOptimizedValue = "CapacityOptimized";

        /// <summary> Default. VM sizes distribution will be determined to optimize for both price and capacity. </summary>
        public static SpotAllocationStrategy PriceCapacityOptimized { get; } = new SpotAllocationStrategy(PriceCapacityOptimizedValue);
        /// <summary> VM sizes distribution will be determined to optimize for price. Note: Capacity will still be considered here but will be given much less weight. </summary>
        public static SpotAllocationStrategy LowestPrice { get; } = new SpotAllocationStrategy(LowestPriceValue);
        /// <summary> VM sizes distribution will be determined to optimize for capacity. </summary>
        public static SpotAllocationStrategy CapacityOptimized { get; } = new SpotAllocationStrategy(CapacityOptimizedValue);
        /// <summary> Determines if two <see cref="SpotAllocationStrategy"/> values are the same. </summary>
        public static bool operator ==(SpotAllocationStrategy left, SpotAllocationStrategy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SpotAllocationStrategy"/> values are not the same. </summary>
        public static bool operator !=(SpotAllocationStrategy left, SpotAllocationStrategy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SpotAllocationStrategy"/>. </summary>
        public static implicit operator SpotAllocationStrategy(string value) => new SpotAllocationStrategy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SpotAllocationStrategy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SpotAllocationStrategy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
