// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Regular VM Allocation strategy types for Compute Fleet. </summary>
    public readonly partial struct RegularPriorityAllocationStrategy : IEquatable<RegularPriorityAllocationStrategy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegularPriorityAllocationStrategy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegularPriorityAllocationStrategy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowestPriceValue = "LowestPrice";
        private const string PrioritizedValue = "Prioritized";

        /// <summary> Default. VM sizes distribution will be determined to optimize for price. </summary>
        public static RegularPriorityAllocationStrategy LowestPrice { get; } = new RegularPriorityAllocationStrategy(LowestPriceValue);
        /// <summary> VM sizes distribution will be determined to optimize for the 'priority' as specified for each vm size. </summary>
        public static RegularPriorityAllocationStrategy Prioritized { get; } = new RegularPriorityAllocationStrategy(PrioritizedValue);
        /// <summary> Determines if two <see cref="RegularPriorityAllocationStrategy"/> values are the same. </summary>
        public static bool operator ==(RegularPriorityAllocationStrategy left, RegularPriorityAllocationStrategy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegularPriorityAllocationStrategy"/> values are not the same. </summary>
        public static bool operator !=(RegularPriorityAllocationStrategy left, RegularPriorityAllocationStrategy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegularPriorityAllocationStrategy"/>. </summary>
        public static implicit operator RegularPriorityAllocationStrategy(string value) => new RegularPriorityAllocationStrategy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegularPriorityAllocationStrategy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegularPriorityAllocationStrategy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
