// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Cpu Manufacturers  supported by Azure VMs. </summary>
    public readonly partial struct CpuManufacturer : IEquatable<CpuManufacturer>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CpuManufacturer"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CpuManufacturer(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IntelValue = "Intel";
        private const string AMDValue = "AMD";
        private const string MicrosoftValue = "Microsoft";
        private const string AmpereValue = "Ampere";

        /// <summary> Intel CPU. </summary>
        public static CpuManufacturer Intel { get; } = new CpuManufacturer(IntelValue);
        /// <summary> AMD CPU. </summary>
        public static CpuManufacturer AMD { get; } = new CpuManufacturer(AMDValue);
        /// <summary> Microsoft CPU. </summary>
        public static CpuManufacturer Microsoft { get; } = new CpuManufacturer(MicrosoftValue);
        /// <summary> Ampere CPU. </summary>
        public static CpuManufacturer Ampere { get; } = new CpuManufacturer(AmpereValue);
        /// <summary> Determines if two <see cref="CpuManufacturer"/> values are the same. </summary>
        public static bool operator ==(CpuManufacturer left, CpuManufacturer right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CpuManufacturer"/> values are not the same. </summary>
        public static bool operator !=(CpuManufacturer left, CpuManufacturer right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CpuManufacturer"/>. </summary>
        public static implicit operator CpuManufacturer(string value) => new CpuManufacturer(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CpuManufacturer other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CpuManufacturer other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
