// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
    /// machines associated to virtual machine scale set with OrchestrationMode as
    /// Flexible.
    /// </summary>
    public readonly partial struct ComputeFleetWindowsVmGuestPatchMode : IEquatable<ComputeFleetWindowsVmGuestPatchMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetWindowsVmGuestPatchMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetWindowsVmGuestPatchMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ManualValue = "Manual";
        private const string AutomaticByOSValue = "AutomaticByOS";
        private const string AutomaticByPlatformValue = "AutomaticByPlatform";

        /// <summary>
        /// You control the application of patches to a virtual machine.
        /// You do this by applying patches manually inside the VM. In this mode,
        /// automatic updates are disabled; the property WindowsConfiguration.enableAutomaticUpdates
        /// must be false
        /// </summary>
        public static ComputeFleetWindowsVmGuestPatchMode Manual { get; } = new ComputeFleetWindowsVmGuestPatchMode(ManualValue);
        /// <summary>
        /// The virtual machine will automatically be updated by the OS.
        /// The property WindowsConfiguration.enableAutomaticUpdates must be true.
        /// </summary>
        public static ComputeFleetWindowsVmGuestPatchMode AutomaticByOS { get; } = new ComputeFleetWindowsVmGuestPatchMode(AutomaticByOSValue);
        /// <summary>
        /// The virtual machine will automatically updated by the platform. The properties
        /// provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
        /// </summary>
        public static ComputeFleetWindowsVmGuestPatchMode AutomaticByPlatform { get; } = new ComputeFleetWindowsVmGuestPatchMode(AutomaticByPlatformValue);
        /// <summary> Determines if two <see cref="ComputeFleetWindowsVmGuestPatchMode"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetWindowsVmGuestPatchMode left, ComputeFleetWindowsVmGuestPatchMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetWindowsVmGuestPatchMode"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetWindowsVmGuestPatchMode left, ComputeFleetWindowsVmGuestPatchMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetWindowsVmGuestPatchMode"/>. </summary>
        public static implicit operator ComputeFleetWindowsVmGuestPatchMode(string value) => new ComputeFleetWindowsVmGuestPatchMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetWindowsVmGuestPatchMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetWindowsVmGuestPatchMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
