// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Specifies the reboot setting for all AutomaticByPlatform patch installation operations. </summary>
    public readonly partial struct ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting : IEquatable<ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string IfRequiredValue = "IfRequired";
        private const string NeverValue = "Never";
        private const string AlwaysValue = "Always";

        /// <summary> Unknown Reboot setting. </summary>
        public static ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting Unknown { get; } = new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(UnknownValue);
        /// <summary> IfRequired Reboot setting. </summary>
        public static ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting IfRequired { get; } = new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(IfRequiredValue);
        /// <summary> Never Reboot setting. </summary>
        public static ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting Never { get; } = new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(NeverValue);
        /// <summary> Always Reboot setting. </summary>
        public static ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting Always { get; } = new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(AlwaysValue);
        /// <summary> Determines if two <see cref="ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting left, ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting left, ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting"/>. </summary>
        public static implicit operator ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(string value) => new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
