// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Describes a virtual machine scale set OS profile. </summary>
    public partial class ComputeFleetVmssOSProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssOSProfile"/>. </summary>
        public ComputeFleetVmssOSProfile()
        {
            Secrets = new ChangeTrackingList<ComputeFleetVaultSecretGroup>();
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssOSProfile"/>. </summary>
        /// <param name="computerNamePrefix">
        /// Specifies the computer name prefix for all of the virtual machines in the scale
        /// set. Computer name prefixes must be 1 to 15 characters long.
        /// </param>
        /// <param name="adminUsername">
        /// Specifies the name of the administrator account. &lt;br&gt;&lt;br&gt; **Windows-only
        /// restriction:** Cannot end in "." &lt;br&gt;&lt;br&gt; **Disallowed values:**
        /// "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3",
        /// "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup",
        /// "console", "david", "guest", "john", "owner", "root", "server", "sql",
        /// "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
        /// &lt;br&gt;&lt;br&gt; **Minimum-length (Linux):** 1  character &lt;br&gt;&lt;br&gt; **Max-length
        /// (Linux):** 64 characters &lt;br&gt;&lt;br&gt; **Max-length (Windows):** 20 characters
        /// </param>
        /// <param name="adminPassword">
        /// Specifies the password of the administrator account. &lt;br&gt;&lt;br&gt; **Minimum-length
        /// (Windows):** 8 characters &lt;br&gt;&lt;br&gt; **Minimum-length (Linux):** 6 characters
        /// &lt;br&gt;&lt;br&gt; **Max-length (Windows):** 123 characters &lt;br&gt;&lt;br&gt; **Max-length
        /// (Linux):** 72 characters &lt;br&gt;&lt;br&gt; **Complexity requirements:** 3 out of 4
        /// conditions below need to be fulfilled &lt;br&gt; Has lower characters &lt;br&gt;Has upper
        /// characters &lt;br&gt; Has a digit &lt;br&gt; Has a special character (Regex match [\W_])
        /// &lt;br&gt;&lt;br&gt; **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
        /// "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
        /// "Password22", "iloveyou!" &lt;br&gt;&lt;br&gt; For resetting the password, see [How to
        /// reset the Remote Desktop service or its login password in a Windows
        /// VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp)
        /// &lt;br&gt;&lt;br&gt; For resetting root password, see [Manage users, SSH, and check or
        /// repair disks on Azure Linux VMs using the VMAccess
        /// Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        /// </param>
        /// <param name="customData">
        /// Specifies a base-64 encoded string of custom data. The base-64 encoded string
        /// is decoded to a binary array that is saved as a file on the Virtual Machine.
        /// The maximum length of the binary array is 65535 bytes. For using cloud-init for
        /// your VM, see [Using cloud-init to customize a Linux VM during
        /// creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        /// </param>
        /// <param name="windowsConfiguration"> Specifies Windows operating system settings on the virtual machine. </param>
        /// <param name="linuxConfiguration">
        /// Specifies the Linux operating system settings on the virtual machine. For a
        /// list of supported Linux distributions, see [Linux on Azure-Endorsed
        /// Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        /// </param>
        /// <param name="secrets">
        /// Specifies set of certificates that should be installed onto the virtual
        /// machines in the scale set. To install certificates on a virtual machine it is
        /// recommended to use the [Azure Key Vault virtual machine extension for
        /// Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux)
        /// or the [Azure Key Vault virtual machine extension for
        /// Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        /// </param>
        /// <param name="areExtensionOperationsAllowed">
        /// Specifies whether extension operations should be allowed on the virtual machine
        /// scale set. This may only be set to False when no extensions are present on the
        /// virtual machine scale set.
        /// </param>
        /// <param name="isGuestProvisionSignalRequired"> Optional property which must either be set to True or omitted. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetVmssOSProfile(string computerNamePrefix, string adminUsername, string adminPassword, string customData, ComputeFleetWindowsConfiguration windowsConfiguration, ComputeFleetLinuxConfiguration linuxConfiguration, IList<ComputeFleetVaultSecretGroup> secrets, bool? areExtensionOperationsAllowed, bool? isGuestProvisionSignalRequired, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ComputerNamePrefix = computerNamePrefix;
            AdminUsername = adminUsername;
            AdminPassword = adminPassword;
            CustomData = customData;
            WindowsConfiguration = windowsConfiguration;
            LinuxConfiguration = linuxConfiguration;
            Secrets = secrets;
            AreExtensionOperationsAllowed = areExtensionOperationsAllowed;
            IsGuestProvisionSignalRequired = isGuestProvisionSignalRequired;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Specifies the computer name prefix for all of the virtual machines in the scale
        /// set. Computer name prefixes must be 1 to 15 characters long.
        /// </summary>
        public string ComputerNamePrefix { get; set; }
        /// <summary>
        /// Specifies the name of the administrator account. &lt;br&gt;&lt;br&gt; **Windows-only
        /// restriction:** Cannot end in "." &lt;br&gt;&lt;br&gt; **Disallowed values:**
        /// "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3",
        /// "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup",
        /// "console", "david", "guest", "john", "owner", "root", "server", "sql",
        /// "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
        /// &lt;br&gt;&lt;br&gt; **Minimum-length (Linux):** 1  character &lt;br&gt;&lt;br&gt; **Max-length
        /// (Linux):** 64 characters &lt;br&gt;&lt;br&gt; **Max-length (Windows):** 20 characters
        /// </summary>
        public string AdminUsername { get; set; }
        /// <summary>
        /// Specifies the password of the administrator account. &lt;br&gt;&lt;br&gt; **Minimum-length
        /// (Windows):** 8 characters &lt;br&gt;&lt;br&gt; **Minimum-length (Linux):** 6 characters
        /// &lt;br&gt;&lt;br&gt; **Max-length (Windows):** 123 characters &lt;br&gt;&lt;br&gt; **Max-length
        /// (Linux):** 72 characters &lt;br&gt;&lt;br&gt; **Complexity requirements:** 3 out of 4
        /// conditions below need to be fulfilled &lt;br&gt; Has lower characters &lt;br&gt;Has upper
        /// characters &lt;br&gt; Has a digit &lt;br&gt; Has a special character (Regex match [\W_])
        /// &lt;br&gt;&lt;br&gt; **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
        /// "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1",
        /// "Password22", "iloveyou!" &lt;br&gt;&lt;br&gt; For resetting the password, see [How to
        /// reset the Remote Desktop service or its login password in a Windows
        /// VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp)
        /// &lt;br&gt;&lt;br&gt; For resetting root password, see [Manage users, SSH, and check or
        /// repair disks on Azure Linux VMs using the VMAccess
        /// Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        /// </summary>
        public string AdminPassword { get; set; }
        /// <summary>
        /// Specifies a base-64 encoded string of custom data. The base-64 encoded string
        /// is decoded to a binary array that is saved as a file on the Virtual Machine.
        /// The maximum length of the binary array is 65535 bytes. For using cloud-init for
        /// your VM, see [Using cloud-init to customize a Linux VM during
        /// creation](https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init)
        /// </summary>
        public string CustomData { get; set; }
        /// <summary> Specifies Windows operating system settings on the virtual machine. </summary>
        public ComputeFleetWindowsConfiguration WindowsConfiguration { get; set; }
        /// <summary>
        /// Specifies the Linux operating system settings on the virtual machine. For a
        /// list of supported Linux distributions, see [Linux on Azure-Endorsed
        /// Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        /// </summary>
        public ComputeFleetLinuxConfiguration LinuxConfiguration { get; set; }
        /// <summary>
        /// Specifies set of certificates that should be installed onto the virtual
        /// machines in the scale set. To install certificates on a virtual machine it is
        /// recommended to use the [Azure Key Vault virtual machine extension for
        /// Linux](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux)
        /// or the [Azure Key Vault virtual machine extension for
        /// Windows](https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows).
        /// </summary>
        public IList<ComputeFleetVaultSecretGroup> Secrets { get; }
        /// <summary>
        /// Specifies whether extension operations should be allowed on the virtual machine
        /// scale set. This may only be set to False when no extensions are present on the
        /// virtual machine scale set.
        /// </summary>
        public bool? AreExtensionOperationsAllowed { get; set; }
        /// <summary> Optional property which must either be set to True or omitted. </summary>
        public bool? IsGuestProvisionSignalRequired { get; set; }
    }
}
