// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Describes the properties of a Virtual Machine Scale Set Extension. </summary>
    public partial class ComputeFleetVmssExtensionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssExtensionProperties"/>. </summary>
        public ComputeFleetVmssExtensionProperties()
        {
            Settings = new ChangeTrackingDictionary<string, BinaryData>();
            ProtectedSettings = new ChangeTrackingDictionary<string, BinaryData>();
            ProvisionAfterExtensions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssExtensionProperties"/>. </summary>
        /// <param name="forceUpdateTag">
        /// If a value is provided and is different from the previous value, the extension
        /// handler will be forced to update even if the extension configuration has not
        /// changed.
        /// </param>
        /// <param name="publisher"> The name of the extension handler publisher. </param>
        /// <param name="extensionType"> Specifies the type of the extension; an example is "CustomScriptExtension". </param>
        /// <param name="typeHandlerVersion"> Specifies the version of the script handler. </param>
        /// <param name="shouldAutoUpgradeMinorVersion">
        /// Indicates whether the extension should use a newer minor version if one is
        /// available at deployment time. Once deployed, however, the extension will not
        /// upgrade minor versions unless redeployed, even with this property set to true.
        /// </param>
        /// <param name="isAutomaticUpgradeEnabled">
        /// Indicates whether the extension should be automatically upgraded by the
        /// platform if there is a newer version of the extension available.
        /// </param>
        /// <param name="settings"> Json formatted public settings for the extension. </param>
        /// <param name="protectedSettings">
        /// The extension can contain either protectedSettings or
        /// protectedSettingsFromKeyVault or no protected settings at all.
        /// </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="provisionAfterExtensions">
        /// Collection of extension names after which this extension needs to be
        /// provisioned.
        /// </param>
        /// <param name="isSuppressFailuresEnabled">
        /// Indicates whether failures stemming from the extension will be suppressed
        /// (Operational failures such as not connecting to the VM will not be suppressed
        /// regardless of this value). The default is false.
        /// </param>
        /// <param name="protectedSettingsFromKeyVault">
        /// The extensions protected settings that are passed by reference, and consumed
        /// from key vault
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetVmssExtensionProperties(string forceUpdateTag, string publisher, string extensionType, string typeHandlerVersion, bool? shouldAutoUpgradeMinorVersion, bool? isAutomaticUpgradeEnabled, IDictionary<string, BinaryData> settings, IDictionary<string, BinaryData> protectedSettings, string provisioningState, IList<string> provisionAfterExtensions, bool? isSuppressFailuresEnabled, ComputeFleetKeyVaultSecretReference protectedSettingsFromKeyVault, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ForceUpdateTag = forceUpdateTag;
            Publisher = publisher;
            ExtensionType = extensionType;
            TypeHandlerVersion = typeHandlerVersion;
            ShouldAutoUpgradeMinorVersion = shouldAutoUpgradeMinorVersion;
            IsAutomaticUpgradeEnabled = isAutomaticUpgradeEnabled;
            Settings = settings;
            ProtectedSettings = protectedSettings;
            ProvisioningState = provisioningState;
            ProvisionAfterExtensions = provisionAfterExtensions;
            IsSuppressFailuresEnabled = isSuppressFailuresEnabled;
            ProtectedSettingsFromKeyVault = protectedSettingsFromKeyVault;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// If a value is provided and is different from the previous value, the extension
        /// handler will be forced to update even if the extension configuration has not
        /// changed.
        /// </summary>
        public string ForceUpdateTag { get; set; }
        /// <summary> The name of the extension handler publisher. </summary>
        public string Publisher { get; set; }
        /// <summary> Specifies the type of the extension; an example is "CustomScriptExtension". </summary>
        public string ExtensionType { get; set; }
        /// <summary> Specifies the version of the script handler. </summary>
        public string TypeHandlerVersion { get; set; }
        /// <summary>
        /// Indicates whether the extension should use a newer minor version if one is
        /// available at deployment time. Once deployed, however, the extension will not
        /// upgrade minor versions unless redeployed, even with this property set to true.
        /// </summary>
        public bool? ShouldAutoUpgradeMinorVersion { get; set; }
        /// <summary>
        /// Indicates whether the extension should be automatically upgraded by the
        /// platform if there is a newer version of the extension available.
        /// </summary>
        public bool? IsAutomaticUpgradeEnabled { get; set; }
        /// <summary>
        /// Json formatted public settings for the extension.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Settings { get; }
        /// <summary>
        /// The extension can contain either protectedSettings or
        /// protectedSettingsFromKeyVault or no protected settings at all.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> ProtectedSettings { get; }
        /// <summary> The provisioning state, which only appears in the response. </summary>
        public string ProvisioningState { get; }
        /// <summary>
        /// Collection of extension names after which this extension needs to be
        /// provisioned.
        /// </summary>
        public IList<string> ProvisionAfterExtensions { get; }
        /// <summary>
        /// Indicates whether failures stemming from the extension will be suppressed
        /// (Operational failures such as not connecting to the VM will not be suppressed
        /// regardless of this value). The default is false.
        /// </summary>
        public bool? IsSuppressFailuresEnabled { get; set; }
        /// <summary>
        /// The extensions protected settings that are passed by reference, and consumed
        /// from key vault
        /// </summary>
        public ComputeFleetKeyVaultSecretReference ProtectedSettingsFromKeyVault { get; set; }
    }
}
