// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Describes a Virtual Machine Scale Set Extension. </summary>
    public partial class ComputeFleetVmssExtension
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssExtension"/>. </summary>
        public ComputeFleetVmssExtension()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmssExtension"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="name"> The name of the extension. </param>
        /// <param name="extensionType"> Resource type. </param>
        /// <param name="properties"> Describes the properties of a Virtual Machine Scale Set Extension. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetVmssExtension(ResourceIdentifier id, string name, string extensionType, ComputeFleetVmssExtensionProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            ExtensionType = extensionType;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource Id. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> The name of the extension. </summary>
        public string Name { get; set; }
        /// <summary> Resource type. </summary>
        public string ExtensionType { get; }
        /// <summary> Describes the properties of a Virtual Machine Scale Set Extension. </summary>
        public ComputeFleetVmssExtensionProperties Properties { get; set; }
    }
}
