// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the required information to reference a compute gallery application
    /// version
    /// </summary>
    public partial class ComputeFleetVmGalleryApplication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmGalleryApplication"/>. </summary>
        /// <param name="packageReferenceId">
        /// Specifies the GalleryApplicationVersion resource id on the form of
        /// /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="packageReferenceId"/> is null. </exception>
        public ComputeFleetVmGalleryApplication(ResourceIdentifier packageReferenceId)
        {
            Argument.AssertNotNull(packageReferenceId, nameof(packageReferenceId));

            PackageReferenceId = packageReferenceId;
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmGalleryApplication"/>. </summary>
        /// <param name="tags"> Optional, Specifies a passthrough value for more generic context. </param>
        /// <param name="order"> Optional, Specifies the order in which the packages have to be installed. </param>
        /// <param name="packageReferenceId">
        /// Specifies the GalleryApplicationVersion resource id on the form of
        /// /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
        /// </param>
        /// <param name="configurationReference">
        /// Optional, Specifies the uri to an azure blob that will replace the default
        /// configuration for the package if provided
        /// </param>
        /// <param name="isTreatFailureAsDeploymentFailureEnabled">
        /// Optional, If true, any failure for any operation in the VmApplication will fail
        /// the deployment
        /// </param>
        /// <param name="isAutomaticUpgradeEnabled">
        /// If set to true, when a new Gallery Application version is available in PIR/SIG,
        /// it will be automatically updated for the VM/VMSS
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetVmGalleryApplication(string tags, int? order, ResourceIdentifier packageReferenceId, string configurationReference, bool? isTreatFailureAsDeploymentFailureEnabled, bool? isAutomaticUpgradeEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Order = order;
            PackageReferenceId = packageReferenceId;
            ConfigurationReference = configurationReference;
            IsTreatFailureAsDeploymentFailureEnabled = isTreatFailureAsDeploymentFailureEnabled;
            IsAutomaticUpgradeEnabled = isAutomaticUpgradeEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmGalleryApplication"/> for deserialization. </summary>
        internal ComputeFleetVmGalleryApplication()
        {
        }

        /// <summary> Optional, Specifies a passthrough value for more generic context. </summary>
        public string Tags { get; set; }
        /// <summary> Optional, Specifies the order in which the packages have to be installed. </summary>
        public int? Order { get; set; }
        /// <summary>
        /// Specifies the GalleryApplicationVersion resource id on the form of
        /// /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}
        /// </summary>
        public ResourceIdentifier PackageReferenceId { get; set; }
        /// <summary>
        /// Optional, Specifies the uri to an azure blob that will replace the default
        /// configuration for the package if provided
        /// </summary>
        public string ConfigurationReference { get; set; }
        /// <summary>
        /// Optional, If true, any failure for any operation in the VmApplication will fail
        /// the deployment
        /// </summary>
        public bool? IsTreatFailureAsDeploymentFailureEnabled { get; set; }
        /// <summary>
        /// If set to true, when a new Gallery Application version is available in PIR/SIG,
        /// it will be automatically updated for the VM/VMSS
        /// </summary>
        public bool? IsAutomaticUpgradeEnabled { get; set; }
    }
}
