// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Specify what happens to the network interface when the VM is deleted. </summary>
    public readonly partial struct ComputeFleetVmDeleteOption : IEquatable<ComputeFleetVmDeleteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmDeleteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetVmDeleteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DetachValue = "Detach";

        /// <summary> Delete Option. </summary>
        public static ComputeFleetVmDeleteOption Delete { get; } = new ComputeFleetVmDeleteOption(DeleteValue);
        /// <summary> Detach Option. </summary>
        public static ComputeFleetVmDeleteOption Detach { get; } = new ComputeFleetVmDeleteOption(DetachValue);
        /// <summary> Determines if two <see cref="ComputeFleetVmDeleteOption"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetVmDeleteOption left, ComputeFleetVmDeleteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetVmDeleteOption"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetVmDeleteOption left, ComputeFleetVmDeleteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetVmDeleteOption"/>. </summary>
        public static implicit operator ComputeFleetVmDeleteOption(string value) => new ComputeFleetVmDeleteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetVmDeleteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetVmDeleteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
