// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> VMSizes supported by Azure VMs. Included is a union of Excluded and Required. </summary>
    public readonly partial struct ComputeFleetVmAttributeSupport : IEquatable<ComputeFleetVmAttributeSupport>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmAttributeSupport"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetVmAttributeSupport(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExcludedValue = "Excluded";
        private const string IncludedValue = "Included";
        private const string RequiredValue = "Required";

        /// <summary> All VMSizes having the feature support will be excluded. </summary>
        public static ComputeFleetVmAttributeSupport Excluded { get; } = new ComputeFleetVmAttributeSupport(ExcludedValue);
        /// <summary> VMSizes that have the feature support and that do not have the feature support will be used. Included is a union of Excluded and Required. </summary>
        public static ComputeFleetVmAttributeSupport Included { get; } = new ComputeFleetVmAttributeSupport(IncludedValue);
        /// <summary> Only the VMSizes having the feature support will be used. </summary>
        public static ComputeFleetVmAttributeSupport Required { get; } = new ComputeFleetVmAttributeSupport(RequiredValue);
        /// <summary> Determines if two <see cref="ComputeFleetVmAttributeSupport"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetVmAttributeSupport left, ComputeFleetVmAttributeSupport right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetVmAttributeSupport"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetVmAttributeSupport left, ComputeFleetVmAttributeSupport right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetVmAttributeSupport"/>. </summary>
        public static implicit operator ComputeFleetVmAttributeSupport(string value) => new ComputeFleetVmAttributeSupport(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetVmAttributeSupport other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetVmAttributeSupport other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
