// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> VMAttributes using double values. </summary>
    public partial class ComputeFleetVmAttributeMinMaxDouble
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmAttributeMinMaxDouble"/>. </summary>
        public ComputeFleetVmAttributeMinMaxDouble()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetVmAttributeMinMaxDouble"/>. </summary>
        /// <param name="min"> Minimum value. default 0. Double.MinValue(). </param>
        /// <param name="max"> Maximum value. Double.MaxValue(1.7976931348623157E+308). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetVmAttributeMinMaxDouble(double? min, double? max, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Min = min;
            Max = max;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Minimum value. default 0. Double.MinValue(). </summary>
        public double? Min { get; set; }
        /// <summary> Maximum value. Double.MaxValue(1.7976931348623157E+308). </summary>
        public double? Max { get; set; }
    }
}
