// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Contains information about SSH certificate public key and the path on the Linux
    /// VM where the public key is placed.
    /// </summary>
    public partial class ComputeFleetSshPublicKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetSshPublicKey"/>. </summary>
        public ComputeFleetSshPublicKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetSshPublicKey"/>. </summary>
        /// <param name="path">
        /// Specifies the full path on the created VM where ssh public key is stored. If
        /// the file already exists, the specified key is appended to the file. Example:
        /// /home/user/.ssh/authorized_keys
        /// </param>
        /// <param name="keyData">
        /// SSH public key certificate used to authenticate with the VM through ssh. The
        /// key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys,
        /// see [Create SSH keys on Linux and Mac for Linux VMs in
        /// Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetSshPublicKey(string path, string keyData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Path = path;
            KeyData = keyData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Specifies the full path on the created VM where ssh public key is stored. If
        /// the file already exists, the specified key is appended to the file. Example:
        /// /home/user/.ssh/authorized_keys
        /// </summary>
        public string Path { get; set; }
        /// <summary>
        /// SSH public key certificate used to authenticate with the VM through ssh. The
        /// key needs to be at least 2048-bit and in ssh-rsa format. For creating ssh keys,
        /// see [Create SSH keys on Linux and Mac for Linux VMs in
        /// Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        /// </summary>
        public string KeyData { get; set; }
    }
}
