// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the SecurityType of the virtual machine. It has to be set to any
    /// specified value to enable UefiSettings. The default behavior is: UefiSettings
    /// will not be enabled unless this property is set.
    /// </summary>
    public readonly partial struct ComputeFleetSecurityType : IEquatable<ComputeFleetSecurityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetSecurityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetSecurityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrustedLaunchValue = "TrustedLaunch";
        private const string ConfidentialVmValue = "ConfidentialVM";

        /// <summary> TrustedLaunch security type. </summary>
        public static ComputeFleetSecurityType TrustedLaunch { get; } = new ComputeFleetSecurityType(TrustedLaunchValue);
        /// <summary> ConfidentialVM security type. </summary>
        public static ComputeFleetSecurityType ConfidentialVm { get; } = new ComputeFleetSecurityType(ConfidentialVmValue);
        /// <summary> Determines if two <see cref="ComputeFleetSecurityType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetSecurityType left, ComputeFleetSecurityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetSecurityType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetSecurityType left, ComputeFleetSecurityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetSecurityType"/>. </summary>
        public static implicit operator ComputeFleetSecurityType(string value) => new ComputeFleetSecurityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetSecurityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetSecurityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
