// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the EncryptionType of the managed disk.
    /// **Note:** It can be set for only Confidential VMs.
    /// </summary>
    public readonly partial struct ComputeFleetSecurityEncryptionType : IEquatable<ComputeFleetSecurityEncryptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetSecurityEncryptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetSecurityEncryptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VmGuestStateOnlyValue = "VMGuestStateOnly";
        private const string DiskWithVmGuestStateValue = "DiskWithVMGuestState";
        private const string NonPersistedTpmValue = "NonPersistedTPM";

        /// <summary>
        /// EncryptionType of the managed disk is set to VMGuestStateOnly for encryption
        /// of just the VMGuestState blob.
        /// </summary>
        public static ComputeFleetSecurityEncryptionType VmGuestStateOnly { get; } = new ComputeFleetSecurityEncryptionType(VmGuestStateOnlyValue);
        /// <summary>
        /// EncryptionType of the managed disk is set to DiskWithVMGuestState for encryption
        /// of the managed disk along with VMGuestState blob.
        /// </summary>
        public static ComputeFleetSecurityEncryptionType DiskWithVmGuestState { get; } = new ComputeFleetSecurityEncryptionType(DiskWithVmGuestStateValue);
        /// <summary>
        /// EncryptionType of the managed disk is set to NonPersistedTPM for not persisting
        /// firmware state in the VMGuestState blob.
        /// </summary>
        public static ComputeFleetSecurityEncryptionType NonPersistedTpm { get; } = new ComputeFleetSecurityEncryptionType(NonPersistedTpmValue);
        /// <summary> Determines if two <see cref="ComputeFleetSecurityEncryptionType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetSecurityEncryptionType left, ComputeFleetSecurityEncryptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetSecurityEncryptionType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetSecurityEncryptionType left, ComputeFleetSecurityEncryptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetSecurityEncryptionType"/>. </summary>
        public static implicit operator ComputeFleetSecurityEncryptionType(string value) => new ComputeFleetSecurityEncryptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetSecurityEncryptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetSecurityEncryptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
