// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Specify public IP sku name. </summary>
    public readonly partial struct ComputeFleetPublicIPAddressSkuName : IEquatable<ComputeFleetPublicIPAddressSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetPublicIPAddressSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetPublicIPAddressSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Basic sku name. </summary>
        public static ComputeFleetPublicIPAddressSkuName Basic { get; } = new ComputeFleetPublicIPAddressSkuName(BasicValue);
        /// <summary> Standard sku name. </summary>
        public static ComputeFleetPublicIPAddressSkuName Standard { get; } = new ComputeFleetPublicIPAddressSkuName(StandardValue);
        /// <summary> Determines if two <see cref="ComputeFleetPublicIPAddressSkuName"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetPublicIPAddressSkuName left, ComputeFleetPublicIPAddressSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetPublicIPAddressSkuName"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetPublicIPAddressSkuName left, ComputeFleetPublicIPAddressSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetPublicIPAddressSkuName"/>. </summary>
        public static implicit operator ComputeFleetPublicIPAddressSkuName(string value) => new ComputeFleetPublicIPAddressSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetPublicIPAddressSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetPublicIPAddressSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
