// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies whether the Auxiliary sku is enabled for the Network Interface
    /// resource.
    /// </summary>
    public readonly partial struct ComputeFleetNetworkInterfaceAuxiliarySku : IEquatable<ComputeFleetNetworkInterfaceAuxiliarySku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetNetworkInterfaceAuxiliarySku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetNetworkInterfaceAuxiliarySku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string A1Value = "A1";
        private const string A2Value = "A2";
        private const string A4Value = "A4";
        private const string A8Value = "A8";

        /// <summary> no sku. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliarySku None { get; } = new ComputeFleetNetworkInterfaceAuxiliarySku(NoneValue);
        /// <summary> A1 sku. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliarySku A1 { get; } = new ComputeFleetNetworkInterfaceAuxiliarySku(A1Value);
        /// <summary> A2 sku. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliarySku A2 { get; } = new ComputeFleetNetworkInterfaceAuxiliarySku(A2Value);
        /// <summary> A4 sku. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliarySku A4 { get; } = new ComputeFleetNetworkInterfaceAuxiliarySku(A4Value);
        /// <summary> A8 sku. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliarySku A8 { get; } = new ComputeFleetNetworkInterfaceAuxiliarySku(A8Value);
        /// <summary> Determines if two <see cref="ComputeFleetNetworkInterfaceAuxiliarySku"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetNetworkInterfaceAuxiliarySku left, ComputeFleetNetworkInterfaceAuxiliarySku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetNetworkInterfaceAuxiliarySku"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetNetworkInterfaceAuxiliarySku left, ComputeFleetNetworkInterfaceAuxiliarySku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetNetworkInterfaceAuxiliarySku"/>. </summary>
        public static implicit operator ComputeFleetNetworkInterfaceAuxiliarySku(string value) => new ComputeFleetNetworkInterfaceAuxiliarySku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetNetworkInterfaceAuxiliarySku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetNetworkInterfaceAuxiliarySku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
