// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies whether the Auxiliary mode is enabled for the Network Interface
    /// resource.
    /// </summary>
    public readonly partial struct ComputeFleetNetworkInterfaceAuxiliaryMode : IEquatable<ComputeFleetNetworkInterfaceAuxiliaryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetNetworkInterfaceAuxiliaryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetNetworkInterfaceAuxiliaryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string AcceleratedConnectionsValue = "AcceleratedConnections";
        private const string FloatingValue = "Floating";

        /// <summary> None Mode. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliaryMode None { get; } = new ComputeFleetNetworkInterfaceAuxiliaryMode(NoneValue);
        /// <summary> AcceleratedConnections Mode. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliaryMode AcceleratedConnections { get; } = new ComputeFleetNetworkInterfaceAuxiliaryMode(AcceleratedConnectionsValue);
        /// <summary> Floating Mode. </summary>
        public static ComputeFleetNetworkInterfaceAuxiliaryMode Floating { get; } = new ComputeFleetNetworkInterfaceAuxiliaryMode(FloatingValue);
        /// <summary> Determines if two <see cref="ComputeFleetNetworkInterfaceAuxiliaryMode"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetNetworkInterfaceAuxiliaryMode left, ComputeFleetNetworkInterfaceAuxiliaryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetNetworkInterfaceAuxiliaryMode"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetNetworkInterfaceAuxiliaryMode left, ComputeFleetNetworkInterfaceAuxiliaryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetNetworkInterfaceAuxiliaryMode"/>. </summary>
        public static implicit operator ComputeFleetNetworkInterfaceAuxiliaryMode(string value) => new ComputeFleetNetworkInterfaceAuxiliaryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetNetworkInterfaceAuxiliaryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetNetworkInterfaceAuxiliaryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
