// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    public partial class ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings : IUtf8JsonSerializable, IJsonModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(RebootSetting))
            {
                writer.WritePropertyName("rebootSetting"u8);
                writer.WriteStringValue(RebootSetting.Value.ToString());
            }
            if (Optional.IsDefined(IsBypassPlatformSafetyChecksOnUserScheduleEnabled))
            {
                writer.WritePropertyName("bypassPlatformSafetyChecksOnUserSchedule"u8);
                writer.WriteBooleanValue(IsBypassPlatformSafetyChecksOnUserScheduleEnabled.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings IJsonModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings(document.RootElement, options);
        }

        internal static ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings DeserializeComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ComputeFleetLinuxVmGuestPatchAutomaticByPlatformRebootSetting? rebootSetting = default;
            bool? bypassPlatformSafetyChecksOnUserSchedule = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("rebootSetting"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebootSetting = new ComputeFleetLinuxVmGuestPatchAutomaticByPlatformRebootSetting(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("bypassPlatformSafetyChecksOnUserSchedule"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bypassPlatformSafetyChecksOnUserSchedule = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings(rebootSetting, bypassPlatformSafetyChecksOnUserSchedule, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings)} does not support writing '{options.Format}' format.");
            }
        }

        ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
