// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
    /// machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You
    /// control the timing of patch assessments on a virtual machine. <br /><br />
    /// **AutomaticByPlatform** - The platform will trigger periodic patch assessments.
    /// The property provisionVMAgent must be true.
    /// </summary>
    public readonly partial struct ComputeFleetLinuxPatchAssessmentMode : IEquatable<ComputeFleetLinuxPatchAssessmentMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetLinuxPatchAssessmentMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetLinuxPatchAssessmentMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageDefaultValue = "ImageDefault";
        private const string AutomaticByPlatformValue = "AutomaticByPlatform";

        /// <summary> You control the timing of patch assessments on a virtual machine. </summary>
        public static ComputeFleetLinuxPatchAssessmentMode ImageDefault { get; } = new ComputeFleetLinuxPatchAssessmentMode(ImageDefaultValue);
        /// <summary> The platform will trigger periodic patch assessments.The property provisionVMAgent must be true. </summary>
        public static ComputeFleetLinuxPatchAssessmentMode AutomaticByPlatform { get; } = new ComputeFleetLinuxPatchAssessmentMode(AutomaticByPlatformValue);
        /// <summary> Determines if two <see cref="ComputeFleetLinuxPatchAssessmentMode"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetLinuxPatchAssessmentMode left, ComputeFleetLinuxPatchAssessmentMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetLinuxPatchAssessmentMode"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetLinuxPatchAssessmentMode left, ComputeFleetLinuxPatchAssessmentMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetLinuxPatchAssessmentMode"/>. </summary>
        public static implicit operator ComputeFleetLinuxPatchAssessmentMode(string value) => new ComputeFleetLinuxPatchAssessmentMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetLinuxPatchAssessmentMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetLinuxPatchAssessmentMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
