// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Inner error details. </summary>
    public partial class ComputeFleetInnerError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetInnerError"/>. </summary>
        internal ComputeFleetInnerError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetInnerError"/>. </summary>
        /// <param name="exceptionType"> The exception type. </param>
        /// <param name="errorDetail"> The internal error message or exception dump. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetInnerError(string exceptionType, string errorDetail, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExceptionType = exceptionType;
            ErrorDetail = errorDetail;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The exception type. </summary>
        public string ExceptionType { get; }
        /// <summary> The internal error message or exception dump. </summary>
        public string ErrorDetail { get; }
    }
}
