// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Available from Api-Version 2017-03-30 onwards, it represents whether the
    /// specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
    /// values are: 'IPv4' and 'IPv6'.
    /// </summary>
    public readonly partial struct ComputeFleetIPVersion : IEquatable<ComputeFleetIPVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetIPVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetIPVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IPv4Value = "IPv4";
        private const string IPv6Value = "IPv6";

        /// <summary> IPv4 version. </summary>
        public static ComputeFleetIPVersion IPv4 { get; } = new ComputeFleetIPVersion(IPv4Value);
        /// <summary> IPv6 version. </summary>
        public static ComputeFleetIPVersion IPv6 { get; } = new ComputeFleetIPVersion(IPv6Value);
        /// <summary> Determines if two <see cref="ComputeFleetIPVersion"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetIPVersion left, ComputeFleetIPVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetIPVersion"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetIPVersion left, ComputeFleetIPVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetIPVersion"/>. </summary>
        public static implicit operator ComputeFleetIPVersion(string value) => new ComputeFleetIPVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetIPVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetIPVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
