// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Different kind of eviction policies. </summary>
    public readonly partial struct ComputeFleetEvictionPolicy : IEquatable<ComputeFleetEvictionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetEvictionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetEvictionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DeallocateValue = "Deallocate";

        /// <summary> When evicted, the Spot VM will be deleted and the corresponding capacity will be updated to reflect this. </summary>
        public static ComputeFleetEvictionPolicy Delete { get; } = new ComputeFleetEvictionPolicy(DeleteValue);
        /// <summary> When evicted, the Spot VM will be deallocated/stopped. </summary>
        public static ComputeFleetEvictionPolicy Deallocate { get; } = new ComputeFleetEvictionPolicy(DeallocateValue);
        /// <summary> Determines if two <see cref="ComputeFleetEvictionPolicy"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetEvictionPolicy left, ComputeFleetEvictionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetEvictionPolicy"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetEvictionPolicy left, ComputeFleetEvictionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetEvictionPolicy"/>. </summary>
        public static implicit operator ComputeFleetEvictionPolicy(string value) => new ComputeFleetEvictionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetEvictionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetEvictionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
