// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the Managed Identity used by ADE to get access token for keyvault
    /// operations.
    /// </summary>
    internal partial class ComputeFleetEncryptionIdentity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetEncryptionIdentity"/>. </summary>
        public ComputeFleetEncryptionIdentity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetEncryptionIdentity"/>. </summary>
        /// <param name="userAssignedIdentityResourceId"> Specifies ARM Resource ID of one of the user identities associated with the VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetEncryptionIdentity(ResourceIdentifier userAssignedIdentityResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserAssignedIdentityResourceId = userAssignedIdentityResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies ARM Resource ID of one of the user identities associated with the VM. </summary>
        public ResourceIdentifier UserAssignedIdentityResourceId { get; set; }
    }
}
