// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// The Domain name label scope.The concatenation of the hashed domain name label
    /// that generated according to the policy from domain name label scope and vm
    /// index will be the domain name labels of the PublicIPAddress resources that will
    /// be created
    /// </summary>
    public readonly partial struct ComputeFleetDomainNameLabelScopeType : IEquatable<ComputeFleetDomainNameLabelScopeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetDomainNameLabelScopeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetDomainNameLabelScopeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TenantReuseValue = "TenantReuse";
        private const string SubscriptionReuseValue = "SubscriptionReuse";
        private const string ResourceGroupReuseValue = "ResourceGroupReuse";
        private const string NoReuseValue = "NoReuse";

        /// <summary> TenantReuse type. </summary>
        public static ComputeFleetDomainNameLabelScopeType TenantReuse { get; } = new ComputeFleetDomainNameLabelScopeType(TenantReuseValue);
        /// <summary> SubscriptionReuse type. </summary>
        public static ComputeFleetDomainNameLabelScopeType SubscriptionReuse { get; } = new ComputeFleetDomainNameLabelScopeType(SubscriptionReuseValue);
        /// <summary> ResourceGroupReuse type. </summary>
        public static ComputeFleetDomainNameLabelScopeType ResourceGroupReuse { get; } = new ComputeFleetDomainNameLabelScopeType(ResourceGroupReuseValue);
        /// <summary> NoReuse type. </summary>
        public static ComputeFleetDomainNameLabelScopeType NoReuse { get; } = new ComputeFleetDomainNameLabelScopeType(NoReuseValue);
        /// <summary> Determines if two <see cref="ComputeFleetDomainNameLabelScopeType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetDomainNameLabelScopeType left, ComputeFleetDomainNameLabelScopeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetDomainNameLabelScopeType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetDomainNameLabelScopeType left, ComputeFleetDomainNameLabelScopeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetDomainNameLabelScopeType"/>. </summary>
        public static implicit operator ComputeFleetDomainNameLabelScopeType(string value) => new ComputeFleetDomainNameLabelScopeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetDomainNameLabelScopeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetDomainNameLabelScopeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
