// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the behavior of the managed disk when the VM gets deleted, for
    /// example whether the managed disk is deleted or detached. Supported values are:
    /// **Delete.** If this value is used, the managed disk is deleted when VM gets
    /// deleted. **Detach.** If this value is used, the managed disk is retained after
    /// VM gets deleted. Minimum api-version: 2021-03-01.
    /// </summary>
    public readonly partial struct ComputeFleetDiskDeleteOptionType : IEquatable<ComputeFleetDiskDeleteOptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetDiskDeleteOptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetDiskDeleteOptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string DetachValue = "Detach";

        /// <summary> If this value is used, the managed disk is deleted when VM gets deleted. </summary>
        public static ComputeFleetDiskDeleteOptionType Delete { get; } = new ComputeFleetDiskDeleteOptionType(DeleteValue);
        /// <summary> If this value is used, the managed disk is retained after VM gets deleted. </summary>
        public static ComputeFleetDiskDeleteOptionType Detach { get; } = new ComputeFleetDiskDeleteOptionType(DetachValue);
        /// <summary> Determines if two <see cref="ComputeFleetDiskDeleteOptionType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetDiskDeleteOptionType left, ComputeFleetDiskDeleteOptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetDiskDeleteOptionType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetDiskDeleteOptionType left, ComputeFleetDiskDeleteOptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetDiskDeleteOptionType"/>. </summary>
        public static implicit operator ComputeFleetDiskDeleteOptionType(string value) => new ComputeFleetDiskDeleteOptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetDiskDeleteOptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetDiskDeleteOptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
