// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the disk controller type configured for the VM and
    /// VirtualMachineScaleSet. This property is only supported for virtual machines
    /// whose operating system disk and VM sku supports Generation 2
    /// (https://docs.microsoft.com/en-us/azure/virtual-machines/generation-2), please
    /// check the HyperVGenerations capability returned as part of VM sku capabilities
    /// in the response of Microsoft.Compute SKUs api for the region contains V2
    /// (https://docs.microsoft.com/rest/api/compute/resourceskus/list). For more
    /// information about Disk Controller Types supported please refer to
    /// https://aka.ms/azure-diskcontrollertypes.
    /// </summary>
    public readonly partial struct ComputeFleetDiskControllerType : IEquatable<ComputeFleetDiskControllerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetDiskControllerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetDiskControllerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScsiValue = "SCSI";
        private const string NvmeValue = "NVMe";

        /// <summary> SCSI disk type. </summary>
        public static ComputeFleetDiskControllerType Scsi { get; } = new ComputeFleetDiskControllerType(ScsiValue);
        /// <summary> NVMe disk type. </summary>
        public static ComputeFleetDiskControllerType Nvme { get; } = new ComputeFleetDiskControllerType(NvmeValue);
        /// <summary> Determines if two <see cref="ComputeFleetDiskControllerType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetDiskControllerType left, ComputeFleetDiskControllerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetDiskControllerType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetDiskControllerType left, ComputeFleetDiskControllerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetDiskControllerType"/>. </summary>
        public static implicit operator ComputeFleetDiskControllerType(string value) => new ComputeFleetDiskControllerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetDiskControllerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetDiskControllerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
