// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the ephemeral disk placement for operating system disk. This property
    /// can be used by user in the request to choose the location i.e, cache disk or
    /// resource disk space for Ephemeral OS disk provisioning. For more information on
    /// Ephemeral OS disk size requirements, please refer Ephemeral OS disk size
    /// requirements for Windows VM at
    /// https://docs.microsoft.com/azure/virtual-machines/windows/ephemeral-os-disks#size-requirements
    /// and Linux VM at
    /// https://docs.microsoft.com/azure/virtual-machines/linux/ephemeral-os-disks#size-requirements
    /// Minimum api-version for NvmeDisk: 2024-03-01.
    /// </summary>
    public readonly partial struct ComputeFleetDiffDiskPlacement : IEquatable<ComputeFleetDiffDiskPlacement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetDiffDiskPlacement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetDiffDiskPlacement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CacheDiskValue = "CacheDisk";
        private const string ResourceDiskValue = "ResourceDisk";
        private const string NvmeDiskValue = "NvmeDisk";

        /// <summary> CacheDisk option. </summary>
        public static ComputeFleetDiffDiskPlacement CacheDisk { get; } = new ComputeFleetDiffDiskPlacement(CacheDiskValue);
        /// <summary> Resource Disk option. </summary>
        public static ComputeFleetDiffDiskPlacement ResourceDisk { get; } = new ComputeFleetDiffDiskPlacement(ResourceDiskValue);
        /// <summary> NvmeDisk option. </summary>
        public static ComputeFleetDiffDiskPlacement NvmeDisk { get; } = new ComputeFleetDiffDiskPlacement(NvmeDiskValue);
        /// <summary> Determines if two <see cref="ComputeFleetDiffDiskPlacement"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetDiffDiskPlacement left, ComputeFleetDiffDiskPlacement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetDiffDiskPlacement"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetDiffDiskPlacement left, ComputeFleetDiffDiskPlacement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetDiffDiskPlacement"/>. </summary>
        public static implicit operator ComputeFleetDiffDiskPlacement(string value) => new ComputeFleetDiffDiskPlacement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetDiffDiskPlacement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetDiffDiskPlacement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
