// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Specifies the ephemeral disk option for operating system disk. </summary>
    public readonly partial struct ComputeFleetDiffDiskOption : IEquatable<ComputeFleetDiffDiskOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetDiffDiskOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetDiffDiskOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocalValue = "Local";

        /// <summary> Local Option. </summary>
        public static ComputeFleetDiffDiskOption Local { get; } = new ComputeFleetDiffDiskOption(LocalValue);
        /// <summary> Determines if two <see cref="ComputeFleetDiffDiskOption"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetDiffDiskOption left, ComputeFleetDiffDiskOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetDiffDiskOption"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetDiffDiskOption left, ComputeFleetDiffDiskOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetDiffDiskOption"/>. </summary>
        public static implicit operator ComputeFleetDiffDiskOption(string value) => new ComputeFleetDiffDiskOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetDiffDiskOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetDiffDiskOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
