// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Specifies the caching requirements. </summary>
    public readonly partial struct ComputeFleetCachingType : IEquatable<ComputeFleetCachingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetCachingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeFleetCachingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ReadOnlyValue = "ReadOnly";
        private const string ReadWriteValue = "ReadWrite";

        /// <summary> 'None' is default for Standard Storage. </summary>
        public static ComputeFleetCachingType None { get; } = new ComputeFleetCachingType(NoneValue);
        /// <summary> 'ReadOnly' is default for Premium Storage. </summary>
        public static ComputeFleetCachingType ReadOnly { get; } = new ComputeFleetCachingType(ReadOnlyValue);
        /// <summary> 'ReadWrite' is default for OS Disk. </summary>
        public static ComputeFleetCachingType ReadWrite { get; } = new ComputeFleetCachingType(ReadWriteValue);
        /// <summary> Determines if two <see cref="ComputeFleetCachingType"/> values are the same. </summary>
        public static bool operator ==(ComputeFleetCachingType left, ComputeFleetCachingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeFleetCachingType"/> values are not the same. </summary>
        public static bool operator !=(ComputeFleetCachingType left, ComputeFleetCachingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeFleetCachingType"/>. </summary>
        public static implicit operator ComputeFleetCachingType(string value) => new ComputeFleetCachingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeFleetCachingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeFleetCachingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
