// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Contains the list of gallery applications that should be made available to the
    /// VM/VMSS
    /// </summary>
    internal partial class ComputeFleetApplicationProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ComputeFleetApplicationProfile"/>. </summary>
        public ComputeFleetApplicationProfile()
        {
            GalleryApplications = new ChangeTrackingList<ComputeFleetVmGalleryApplication>();
        }

        /// <summary> Initializes a new instance of <see cref="ComputeFleetApplicationProfile"/>. </summary>
        /// <param name="galleryApplications"> Specifies the gallery applications that should be made available to the VM/VMSS. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ComputeFleetApplicationProfile(IList<ComputeFleetVmGalleryApplication> galleryApplications, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GalleryApplications = galleryApplications;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the gallery applications that should be made available to the VM/VMSS. </summary>
        public IList<ComputeFleetVmGalleryApplication> GalleryApplications { get; }
    }
}
