// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary>
    /// Specifies the name of the setting to which the content applies. Possible values
    /// are: FirstLogonCommands and AutoLogon.
    /// </summary>
    public readonly partial struct AdditionalInformationSettingName : IEquatable<AdditionalInformationSettingName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AdditionalInformationSettingName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AdditionalInformationSettingName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoLogonValue = "AutoLogon";
        private const string FirstLogonCommandsValue = "FirstLogonCommands";

        /// <summary> AutoLogon setting. </summary>
        public static AdditionalInformationSettingName AutoLogon { get; } = new AdditionalInformationSettingName(AutoLogonValue);
        /// <summary> FirstLogonCommands setting. </summary>
        public static AdditionalInformationSettingName FirstLogonCommands { get; } = new AdditionalInformationSettingName(FirstLogonCommandsValue);
        /// <summary> Determines if two <see cref="AdditionalInformationSettingName"/> values are the same. </summary>
        public static bool operator ==(AdditionalInformationSettingName left, AdditionalInformationSettingName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AdditionalInformationSettingName"/> values are not the same. </summary>
        public static bool operator !=(AdditionalInformationSettingName left, AdditionalInformationSettingName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AdditionalInformationSettingName"/>. </summary>
        public static implicit operator AdditionalInformationSettingName(string value) => new AdditionalInformationSettingName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AdditionalInformationSettingName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AdditionalInformationSettingName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
