// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Accelerator types supported by Azure VMs. </summary>
    public readonly partial struct AcceleratorType : IEquatable<AcceleratorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcceleratorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcceleratorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GPUValue = "GPU";
        private const string FPGAValue = "FPGA";

        /// <summary> GPU Accelerator. </summary>
        public static AcceleratorType GPU { get; } = new AcceleratorType(GPUValue);
        /// <summary> FPGA Accelerator. </summary>
        public static AcceleratorType FPGA { get; } = new AcceleratorType(FPGAValue);
        /// <summary> Determines if two <see cref="AcceleratorType"/> values are the same. </summary>
        public static bool operator ==(AcceleratorType left, AcceleratorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcceleratorType"/> values are not the same. </summary>
        public static bool operator !=(AcceleratorType left, AcceleratorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcceleratorType"/>. </summary>
        public static implicit operator AcceleratorType(string value) => new AcceleratorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcceleratorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcceleratorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
