// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ComputeFleet.Models
{
    /// <summary> Accelerator manufacturers supported by Azure VMs. </summary>
    public readonly partial struct AcceleratorManufacturer : IEquatable<AcceleratorManufacturer>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcceleratorManufacturer"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcceleratorManufacturer(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AMDValue = "AMD";
        private const string NvidiaValue = "Nvidia";
        private const string XilinxValue = "Xilinx";

        /// <summary> AMD GpuType. </summary>
        public static AcceleratorManufacturer AMD { get; } = new AcceleratorManufacturer(AMDValue);
        /// <summary> Nvidia GpuType. </summary>
        public static AcceleratorManufacturer Nvidia { get; } = new AcceleratorManufacturer(NvidiaValue);
        /// <summary> Xilinx GpuType. </summary>
        public static AcceleratorManufacturer Xilinx { get; } = new AcceleratorManufacturer(XilinxValue);
        /// <summary> Determines if two <see cref="AcceleratorManufacturer"/> values are the same. </summary>
        public static bool operator ==(AcceleratorManufacturer left, AcceleratorManufacturer right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcceleratorManufacturer"/> values are not the same. </summary>
        public static bool operator !=(AcceleratorManufacturer left, AcceleratorManufacturer right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcceleratorManufacturer"/>. </summary>
        public static implicit operator AcceleratorManufacturer(string value) => new AcceleratorManufacturer(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcceleratorManufacturer other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcceleratorManufacturer other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
