// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet
{
    internal class ComputeFleetOperationSource : IOperationSource<ComputeFleetResource>
    {
        private readonly ArmClient _client;

        internal ComputeFleetOperationSource(ArmClient client)
        {
            _client = client;
        }

        ComputeFleetResource IOperationSource<ComputeFleetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ComputeFleetData.DeserializeComputeFleetData(document.RootElement);
            return new ComputeFleetResource(_client, data);
        }

        async ValueTask<ComputeFleetResource> IOperationSource<ComputeFleetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ComputeFleetData.DeserializeComputeFleetData(document.RootElement);
            return new ComputeFleetResource(_client, data);
        }
    }
}
