// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableComputeFleetResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableComputeFleetResourceGroupResource"/> class for mocking. </summary>
        protected MockableComputeFleetResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableComputeFleetResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableComputeFleetResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ComputeFleetResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of ComputeFleetResources and their operations over a ComputeFleetResource. </returns>
        public virtual ComputeFleetCollection GetComputeFleets()
        {
            return GetCachedClient(client => new ComputeFleetCollection(client, Id));
        }

        /// <summary>
        /// Get a Fleet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Fleet_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComputeFleetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fleetName"> The name of the Compute Fleet. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fleetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="fleetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ComputeFleetResource>> GetComputeFleetAsync(string fleetName, CancellationToken cancellationToken = default)
        {
            return await GetComputeFleets().GetAsync(fleetName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a Fleet
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Fleet_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ComputeFleetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="fleetName"> The name of the Compute Fleet. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="fleetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="fleetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ComputeFleetResource> GetComputeFleet(string fleetName, CancellationToken cancellationToken = default)
        {
            return GetComputeFleets().Get(fleetName, cancellationToken);
        }
    }
}
