// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ComputeFleet.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableComputeFleetArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableComputeFleetArmClient"/> class for mocking. </summary>
        protected MockableComputeFleetArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableComputeFleetArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableComputeFleetArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableComputeFleetArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="ComputeFleetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ComputeFleetResource.CreateResourceIdentifier" /> to create a <see cref="ComputeFleetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ComputeFleetResource"/> object. </returns>
        public virtual ComputeFleetResource GetComputeFleetResource(ResourceIdentifier id)
        {
            ComputeFleetResource.ValidateResourceId(id);
            return new ComputeFleetResource(Client, id);
        }
    }
}
