// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ComputeFleet.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ComputeFleet.Samples
{
    public partial class Sample_ComputeFleetResource
    {
        // Fleets_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_FleetsGet()
        {
            // Generated from example definition: 2024-11-01/Fleets_Get.json
            // this example is just showing the usage of "Fleet_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ComputeFleetResource created on azure
            // for more information of creating ComputeFleetResource, please refer to the document of ComputeFleetResource
            string subscriptionId = "1DC2F28C-A625-4B0E-9748-9885A3C9E9EB";
            string resourceGroupName = "rgazurefleet";
            string fleetName = "testFleet";
            ResourceIdentifier computeFleetResourceId = ComputeFleetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fleetName);
            ComputeFleetResource computeFleet = client.GetComputeFleetResource(computeFleetResourceId);

            // invoke the operation
            ComputeFleetResource result = await computeFleet.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ComputeFleetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Fleets_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_FleetsUpdate()
        {
            // Generated from example definition: 2024-11-01/Fleets_Update.json
            // this example is just showing the usage of "Fleet_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ComputeFleetResource created on azure
            // for more information of creating ComputeFleetResource, please refer to the document of ComputeFleetResource
            string subscriptionId = "1DC2F28C-A625-4B0E-9748-9885A3C9E9EB";
            string resourceGroupName = "rgazurefleet";
            string fleetName = "testFleet";
            ResourceIdentifier computeFleetResourceId = ComputeFleetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fleetName);
            ComputeFleetResource computeFleet = client.GetComputeFleetResource(computeFleetResourceId);

            // invoke the operation
            ComputeFleetPatch patch = new ComputeFleetPatch()
            {
                Tags =
{
},
                Identity = new ManagedServiceIdentity(default),
                Plan = new ArmPlan("jwgrcrnrtfoxn", "iozjbiqqckqm", "cgopbyvdyqikahwyxfpzwaqk")
                {
                    PromotionCode = "naglezezplcaruqogtxnuizslqnnbr",
                    Version = "wa",
                },
                Properties = new ComputeFleetProperties(new ComputeFleetVmSizeProfile[]
            {
new ComputeFleetVmSizeProfile("Standard_d1_v2")
{
Rank = 19225,
}
            }, new ComputeFleetComputeProfile(new ComputeFleetVmProfile()
            {
                OSProfile = new ComputeFleetVmssOSProfile()
                {
                    ComputerNamePrefix = "o",
                    AdminUsername = "nrgzqciiaaxjrqldbmjbqkyhntp",
                    AdminPassword = "adfbrdxpv",
                    CustomData = "xjjib",
                    WindowsConfiguration = new ComputeFleetWindowsConfiguration()
                    {
                        IsVmAgentProvisioned = true,
                        IsAutomaticUpdatesEnabled = true,
                        TimeZone = "hlyjiqcfksgrpjrct",
                        AdditionalUnattendContent =
            {
new WindowsSetupAdditionalInformation()
{
PassName = WindowsSetupAdditionalInformationPassName.OobeSystem,
ComponentName = WindowsSetupAdditionalInformationComponentName.MicrosoftWindowsShellSetup,
SettingName = AdditionalInformationSettingName.AutoLogon,
Content = "bubmqbxjkj",
}
            },
                        PatchSettings = new ComputeFleetVmGuestPatchSettings()
                        {
                            PatchMode = ComputeFleetWindowsVmGuestPatchMode.Manual,
                            IsHotPatchingEnabled = true,
                            AssessmentMode = ComputeFleetWindowsPatchAssessmentMode.ImageDefault,
                            AutomaticByPlatformSettings = new ComputeFleetWindowsVmGuestPatchAutomaticByPlatformSettings()
                            {
                                RebootSetting = ComputeFleetWindowsVmGuestPatchAutomaticByPlatformRebootSetting.Unknown,
                                IsBypassPlatformSafetyChecksOnUserScheduleEnabled = true,
                            },
                        },
                        WinRMListeners =
            {
new ComputeFleetWinRMListener()
{
Protocol = ComputeFleetProtocolType.Http,
CertificateUri = new Uri("https://myVaultName.vault.azure.net/secrets/myCertName"),
}
            },
                        IsVmAgentPlatformUpdatesEnabled = true,
                    },
                    LinuxConfiguration = new ComputeFleetLinuxConfiguration()
                    {
                        IsPasswordAuthenticationDisabled = true,
                        SshPublicKeys =
            {
new ComputeFleetSshPublicKey()
{
Path = "kmqz",
KeyData = "kivgsubusvpprwqaqpjcmhsv",
}
            },
                        IsVmAgentProvisioned = true,
                        PatchSettings = new ComputeFleetLinuxPatchSettings()
                        {
                            PatchMode = ComputeFleetLinuxVmGuestPatchMode.ImageDefault,
                            AssessmentMode = ComputeFleetLinuxPatchAssessmentMode.ImageDefault,
                            AutomaticByPlatformSettings = new ComputeFleetLinuxVmGuestPatchAutomaticByPlatformSettings()
                            {
                                RebootSetting = ComputeFleetLinuxVmGuestPatchAutomaticByPlatformRebootSetting.Unknown,
                                IsBypassPlatformSafetyChecksOnUserScheduleEnabled = true,
                            },
                        },
                        IsVmAgentPlatformUpdatesEnabled = true,
                    },
                    Secrets =
            {
new ComputeFleetVaultSecretGroup()
{
SourceVaultId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}"),
VaultCertificates =
{
new ComputeFleetVaultCertificate()
{
CertificateUri = new Uri("https://myVaultName.vault.azure.net/secrets/myCertName"),
CertificateStore = "nlxrwavpzhueffxsshlun",
}
},
}
            },
                    AreExtensionOperationsAllowed = true,
                    IsGuestProvisionSignalRequired = true,
                },
                StorageProfile = new ComputeFleetVmssStorageProfile()
                {
                    ImageReference = new ComputeFleetImageReference()
                    {
                        Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageName}/versions/{versionName}"),
                        Publisher = "mqxgwbiyjzmxavhbkd",
                        Offer = "isxgumkarlkomp",
                        Sku = "eojmppqcrnpmxirtp",
                        Version = "wvpcqefgtmqdgltiuz",
                        SharedGalleryImageId = "kmkgihoxwlawuuhcinfirktdwkmx",
                        CommunityGalleryImageId = "vlqe",
                    },
                    OSDisk = new ComputeFleetVmssOSDisk(ComputeFleetDiskCreateOptionType.FromImage)
                    {
                        Name = "wfttw",
                        Caching = ComputeFleetCachingType.None,
                        IsWriteAcceleratorEnabled = true,
                        DiffDiskSettings = new ComputeFleetDiffDiskSettings()
                        {
                            Option = ComputeFleetDiffDiskOption.Local,
                            Placement = ComputeFleetDiffDiskPlacement.CacheDisk,
                        },
                        DiskSizeGB = 14,
                        OSType = ComputeFleetOperatingSystemType.Windows,
                        ImageUri = new Uri("https://myStorageAccountName.blob.core.windows.net/myContainerName/myVhdName.vhd"),
                        VhdContainers =
            {
"tkzcwddtinkfpnfklatw"
            },
                        ManagedDisk = new ComputeFleetVmssManagedDisk()
                        {
                            StorageAccountType = ComputeFleetStorageAccountType.StandardLrs,
                            DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
                            SecurityProfile = new ComputeFleetVmDiskSecurityProfile()
                            {
                                SecurityEncryptionType = ComputeFleetSecurityEncryptionType.VmGuestStateOnly,
                                DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
                            },
                        },
                        DeleteOption = ComputeFleetDiskDeleteOptionType.Delete,
                    },
                    DataDisks =
            {
new ComputeFleetVmssDataDisk(14,ComputeFleetDiskCreateOptionType.FromImage)
{
Name = "eogiykmdmeikswxmigjws",
Caching = ComputeFleetCachingType.None,
IsWriteAcceleratorEnabled = true,
DiskSizeGB = 6,
ManagedDisk = new ComputeFleetVmssManagedDisk()
{
StorageAccountType = ComputeFleetStorageAccountType.StandardLrs,
DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
SecurityProfile = new ComputeFleetVmDiskSecurityProfile()
{
SecurityEncryptionType = ComputeFleetSecurityEncryptionType.VmGuestStateOnly,
DiskEncryptionSetId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{diskEncryptionSetName}"),
},
},
DiskIopsReadWrite = 27L,
DiskMbpsReadWrite = 2L,
DeleteOption = ComputeFleetDiskDeleteOptionType.Delete,
}
            },
                },
                NetworkProfile = new ComputeFleetVmssNetworkProfile()
                {
                    HealthProbeId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}"),
                    NetworkInterfaceConfigurations =
            {
new ComputeFleetVmssNetworkConfiguration("i")
{
Properties = new ComputeFleetVmssNetworkConfigurationProperties(new ComputeFleetVmssIPConfiguration[]
{
new ComputeFleetVmssIPConfiguration("oezqhkidfhyywlfzwuotilrpbqnjg")
{
Properties = new ComputeFleetVmssIPConfigurationProperties()
{
SubnetId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}"),
IsPrimary = true,
PublicIPAddressConfiguration = new ComputeFleetVmssPublicIPAddressConfiguration("fvpqf")
{
Properties = new ComputeFleetVmssPublicIPAddressConfigurationProperties()
{
IdleTimeoutInMinutes = 9,
DnsSettings = new ComputeFleetVmssPublicIPAddressDnsSettings("ukrddzvmorpmfsczjwtbvp")
{
DomainNameLabelScope = ComputeFleetDomainNameLabelScopeType.TenantReuse,
},
IPTags =
{
new ComputeFleetVmssIPTag()
{
IPTagType = "sddgsoemnzgqizale",
Tag = "wufmhrjsakbiaetyara",
}
},
PublicIPPrefixId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}"),
PublicIPAddressVersion = ComputeFleetIPVersion.IPv4,
DeleteOption = ComputeFleetVmDeleteOption.Delete,
},
Sku = new ComputeFleetPublicIPAddressSku()
{
Name = ComputeFleetPublicIPAddressSkuName.Basic,
Tier = ComputeFleetPublicIPAddressSkuTier.Regional,
},
},
PrivateIPAddressVersion = ComputeFleetIPVersion.IPv4,
ApplicationGatewayBackendAddressPools =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendAddressPools/{backendAddressPoolName}"),
}
},
ApplicationSecurityGroups =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationSecurityGroups/{applicationSecurityGroupName}"),
}
},
LoadBalancerBackendAddressPools =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}"),
}
},
LoadBalancerInboundNatPools =
{
new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatPools/{inboundNatPoolName}"),
}
},
},
}
})
{
IsPrimary = true,
IsAcceleratedNetworkingEnabled = true,
IsTcpStateTrackingDisabled = true,
IsFpgaEnabled = true,
NetworkSecurityGroupId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityGroups/{networkSecurityGroupName}"),
DnsServers =
{
"nxmmfolhclsesu"
},
IsIPForwardingEnabled = true,
DeleteOption = ComputeFleetVmDeleteOption.Delete,
AuxiliaryMode = ComputeFleetNetworkInterfaceAuxiliaryMode.None,
AuxiliarySku = ComputeFleetNetworkInterfaceAuxiliarySku.None,
},
}
            },
                    NetworkApiVersion = ComputeFleetNetworkApiVersion.V20201101,
                },
                SecurityProfile = new ComputeFleetSecurityProfile()
                {
                    UefiSettings = new ComputeFleetUefiSettings()
                    {
                        IsSecureBootEnabled = true,
                        IsVTpmEnabled = true,
                    },
                    IsEncryptionAtHostEnabled = true,
                    SecurityType = ComputeFleetSecurityType.TrustedLaunch,
                    UserAssignedIdentityResourceId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{userAssignedIdentityName}"),
                    ProxyAgentSettings = new ComputeFleetProxyAgentSettings()
                    {
                        IsEnabled = true,
                        Mode = ProxyAgentExecuteMode.Audit,
                        KeyIncarnationId = 20,
                    },
                },
                BootDiagnostics = new ComputeFleetBootDiagnostics()
                {
                    IsEnabled = true,
                    StorageUri = new Uri("http://myStorageAccountName.blob.core.windows.net"),
                },
                ExtensionProfile = new ComputeFleetVmssExtensionProfile()
                {
                    Extensions =
            {
new ComputeFleetVmssExtension()
{
Name = "bndxuxx",
Properties = new ComputeFleetVmssExtensionProperties()
{
ForceUpdateTag = "yhgxw",
Publisher = "kpxtirxjfprhs",
ExtensionType = "pgjilctjjwaa",
TypeHandlerVersion = "zevivcoilxmbwlrihhhibq",
ShouldAutoUpgradeMinorVersion = true,
IsAutomaticUpgradeEnabled = true,
Settings =
{
},
ProtectedSettings =
{
},
ProvisionAfterExtensions =
{
"nftzosroolbcwmpupujzqwqe"
},
IsSuppressFailuresEnabled = true,
ProtectedSettingsFromKeyVault = new ComputeFleetKeyVaultSecretReference(new Uri("https://myVaultName.vault.azure.net/secrets/secret/mySecretName"),new WritableSubResource()
{
Id = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}"),
}),
},
}
            },
                    ExtensionsTimeBudget = "mbhjahtdygwgyszdwjtvlvtgchdwil",
                },
                LicenseType = "v",
                ScheduledEventsProfile = new ComputeFleetScheduledEventsProfile()
                {
                    TerminateNotificationProfile = new ComputeFleetTerminateNotificationProfile()
                    {
                        NotBeforeTimeout = "iljppmmw",
                        IsEnabled = true,
                    },
                    OSImageNotificationProfile = new ComputeFleetOSImageNotificationProfile()
                    {
                        NotBeforeTimeout = "olbpadmevekyczfokodtfprxti",
                        IsEnabled = true,
                    },
                },
                UserData = "s",
                CapacityReservationGroupId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}"),
                GalleryApplications =
            {
new ComputeFleetVmGalleryApplication(new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{applicationName}/versions/{versionName}"))
{
Tags = "eyrqjbib",
Order = 5,
ConfigurationReference = "ulztmiavpojpbpbddgnuuiimxcpau",
IsTreatFailureAsDeploymentFailureEnabled = true,
IsAutomaticUpgradeEnabled = true,
}
            },
                HardwareVmSizeProperties = new ComputeFleetVmSizeProperties()
                {
                    VCPUsAvailable = 16,
                    VCPUsPerCore = 23,
                },
                ServiceArtifactReferenceId = new ResourceIdentifier("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/serviceArtifacts/{serviceArtifactsName}/vmArtifactsProfiles/{vmArtifactsProfileName}"),
                SecurityPostureReference = new ComputeFleetSecurityPostureReference()
                {
                    Id = "/CommunityGalleries/{communityGalleryName}/securityPostures/{securityPostureName}/versions/{major.minor.patch}|{major.*}|latest",
                    ExcludeExtensions =
            {
"{securityPostureVMExtensionName}"
            },
                    IsOverridable = true,
                },
            })
            {
                ComputeApiVersion = "2023-07-01",
                PlatformFaultDomainCount = 1,
            })
                {
                    SpotPriorityProfile = new SpotPriorityProfile()
                    {
                        Capacity = 20,
                        MinCapacity = 10,
                        MaxPricePerVm = 0.00865F,
                        EvictionPolicy = ComputeFleetEvictionPolicy.Delete,
                        AllocationStrategy = SpotAllocationStrategy.PriceCapacityOptimized,
                        IsMaintainEnabled = true,
                    },
                    RegularPriorityProfile = new RegularPriorityProfile()
                    {
                        Capacity = 20,
                        MinCapacity = 10,
                        AllocationStrategy = RegularPriorityAllocationStrategy.LowestPrice,
                    },
                },
            };
            ArmOperation<ComputeFleetResource> lro = await computeFleet.UpdateAsync(WaitUntil.Completed, patch);
            ComputeFleetResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ComputeFleetData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Fleets_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_FleetsDelete()
        {
            // Generated from example definition: 2024-11-01/Fleets_Delete.json
            // this example is just showing the usage of "Fleet_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ComputeFleetResource created on azure
            // for more information of creating ComputeFleetResource, please refer to the document of ComputeFleetResource
            string subscriptionId = "1DC2F28C-A625-4B0E-9748-9885A3C9E9EB";
            string resourceGroupName = "rgazurefleet";
            string fleetName = "testFleet";
            ResourceIdentifier computeFleetResourceId = ComputeFleetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, fleetName);
            ComputeFleetResource computeFleet = client.GetComputeFleetResource(computeFleetResourceId);

            // invoke the operation
            await computeFleet.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Fleets_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetComputeFleets_FleetsListBySubscription()
        {
            // Generated from example definition: 2024-11-01/Fleets_ListBySubscription.json
            // this example is just showing the usage of "Fleet_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "1DC2F28C-A625-4B0E-9748-9885A3C9E9EB";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (ComputeFleetResource item in subscriptionResource.GetComputeFleetsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ComputeFleetData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Fleets_ListVirtualMachineScaleSets
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetVirtualMachineScaleSets_FleetsListVirtualMachineScaleSets()
        {
            // Generated from example definition: 2024-11-01/Fleets_ListVirtualMachineScaleSets.json
            // this example is just showing the usage of "VirtualMachineScaleSet_ListVirtualMachineScaleSets" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ComputeFleetResource created on azure
            // for more information of creating ComputeFleetResource, please refer to the document of ComputeFleetResource
            string subscriptionId = "1DC2F28C-A625-4B0E-9748-9885A3C9E9EB";
            string resourceGroupName = "rgazurefleet";
            string name = "myFleet";
            ResourceIdentifier computeFleetResourceId = ComputeFleetResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, name);
            ComputeFleetResource computeFleet = client.GetComputeFleetResource(computeFleetResourceId);

            // invoke the operation and iterate over the result
            await foreach (ComputeFleetVmss item in computeFleet.GetVirtualMachineScaleSetsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
