// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Compute.Models;

namespace Azure.ResourceManager.Compute
{
    /// <summary>
    /// A class representing the SharedGallery data model.
    /// Specifies information about the Shared Gallery that you want to create or update.
    /// </summary>
    public partial class SharedGalleryData : PirSharedGalleryResourceData
    {
        /// <summary> Initializes a new instance of <see cref="SharedGalleryData"/>. </summary>
        internal SharedGalleryData()
        {
            ArtifactTags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SharedGalleryData"/>. </summary>
        /// <param name="name"> Resource name. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="uniqueId"> The unique id of this shared gallery. </param>
        /// <param name="artifactTags"> The artifact tags of a shared gallery resource. </param>
        internal SharedGalleryData(string name, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, string uniqueId, IReadOnlyDictionary<string, string> artifactTags) : base(name, location, serializedAdditionalRawData, uniqueId)
        {
            ArtifactTags = artifactTags;
        }

        /// <summary> The artifact tags of a shared gallery resource. </summary>
        public IReadOnlyDictionary<string, string> ArtifactTags { get; }
        /// <summary> The resource identifier. </summary>
        public ResourceIdentifier Id { get; internal set; }
    }
}
