// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the mode of VM Guest patch assessment for the IaaS virtual machine.&lt;br /&gt;&lt;br /&gt; Possible values are:&lt;br /&gt;&lt;br /&gt; **ImageDefault** - You control the timing of patch assessments on a virtual machine.&lt;br /&gt;&lt;br /&gt; **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true. </summary>
    public readonly partial struct WindowsPatchAssessmentMode : IEquatable<WindowsPatchAssessmentMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WindowsPatchAssessmentMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WindowsPatchAssessmentMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ImageDefaultValue = "ImageDefault";
        private const string AutomaticByPlatformValue = "AutomaticByPlatform";

        /// <summary> ImageDefault. </summary>
        public static WindowsPatchAssessmentMode ImageDefault { get; } = new WindowsPatchAssessmentMode(ImageDefaultValue);
        /// <summary> AutomaticByPlatform. </summary>
        public static WindowsPatchAssessmentMode AutomaticByPlatform { get; } = new WindowsPatchAssessmentMode(AutomaticByPlatformValue);
        /// <summary> Determines if two <see cref="WindowsPatchAssessmentMode"/> values are the same. </summary>
        public static bool operator ==(WindowsPatchAssessmentMode left, WindowsPatchAssessmentMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WindowsPatchAssessmentMode"/> values are not the same. </summary>
        public static bool operator !=(WindowsPatchAssessmentMode left, WindowsPatchAssessmentMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WindowsPatchAssessmentMode"/>. </summary>
        public static implicit operator WindowsPatchAssessmentMode(string value) => new WindowsPatchAssessmentMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WindowsPatchAssessmentMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WindowsPatchAssessmentMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
