// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The VmGuestPatchClassificationForWindows. </summary>
    public readonly partial struct VmGuestPatchClassificationForWindows : IEquatable<VmGuestPatchClassificationForWindows>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VmGuestPatchClassificationForWindows"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VmGuestPatchClassificationForWindows(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CriticalValue = "Critical";
        private const string SecurityValue = "Security";
        private const string UpdateRollUpValue = "UpdateRollUp";
        private const string FeaturePackValue = "FeaturePack";
        private const string ServicePackValue = "ServicePack";
        private const string DefinitionValue = "Definition";
        private const string ToolsValue = "Tools";
        private const string UpdatesValue = "Updates";

        /// <summary> Critical. </summary>
        public static VmGuestPatchClassificationForWindows Critical { get; } = new VmGuestPatchClassificationForWindows(CriticalValue);
        /// <summary> Security. </summary>
        public static VmGuestPatchClassificationForWindows Security { get; } = new VmGuestPatchClassificationForWindows(SecurityValue);
        /// <summary> UpdateRollUp. </summary>
        public static VmGuestPatchClassificationForWindows UpdateRollUp { get; } = new VmGuestPatchClassificationForWindows(UpdateRollUpValue);
        /// <summary> FeaturePack. </summary>
        public static VmGuestPatchClassificationForWindows FeaturePack { get; } = new VmGuestPatchClassificationForWindows(FeaturePackValue);
        /// <summary> ServicePack. </summary>
        public static VmGuestPatchClassificationForWindows ServicePack { get; } = new VmGuestPatchClassificationForWindows(ServicePackValue);
        /// <summary> Definition. </summary>
        public static VmGuestPatchClassificationForWindows Definition { get; } = new VmGuestPatchClassificationForWindows(DefinitionValue);
        /// <summary> Tools. </summary>
        public static VmGuestPatchClassificationForWindows Tools { get; } = new VmGuestPatchClassificationForWindows(ToolsValue);
        /// <summary> Updates. </summary>
        public static VmGuestPatchClassificationForWindows Updates { get; } = new VmGuestPatchClassificationForWindows(UpdatesValue);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationForWindows"/> values are the same. </summary>
        public static bool operator ==(VmGuestPatchClassificationForWindows left, VmGuestPatchClassificationForWindows right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VmGuestPatchClassificationForWindows"/> values are not the same. </summary>
        public static bool operator !=(VmGuestPatchClassificationForWindows left, VmGuestPatchClassificationForWindows right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VmGuestPatchClassificationForWindows"/>. </summary>
        public static implicit operator VmGuestPatchClassificationForWindows(string value) => new VmGuestPatchClassificationForWindows(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VmGuestPatchClassificationForWindows other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VmGuestPatchClassificationForWindows other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
