// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes a Virtual Machine Scale Set VM Reimage Parameters. </summary>
    public partial class VirtualMachineScaleSetVmReimageContent : VirtualMachineReimageContent
    {
        /// <summary> Initializes a new instance of <see cref="VirtualMachineScaleSetVmReimageContent"/>. </summary>
        public VirtualMachineScaleSetVmReimageContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualMachineScaleSetVmReimageContent"/>. </summary>
        /// <param name="tempDisk"> Specifies whether to reimage temp disk. Default value: false. Note: This temp disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk. </param>
        /// <param name="exactVersion"> Specifies in decimal number, the version the OS disk should be reimaged to. If exact version is not provided, the OS disk is reimaged to the existing version of OS Disk. </param>
        /// <param name="osProfile"> Specifies information required for reimaging the non-ephemeral OS disk. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="forceUpdateOSDiskForEphemeral"> Parameter to force update ephemeral OS disk for a virtual machine scale set VM. </param>
        internal VirtualMachineScaleSetVmReimageContent(bool? tempDisk, string exactVersion, OSProfileProvisioningData osProfile, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? forceUpdateOSDiskForEphemeral) : base(tempDisk, exactVersion, osProfile, serializedAdditionalRawData)
        {
            ForceUpdateOSDiskForEphemeral = forceUpdateOSDiskForEphemeral;
        }

        /// <summary> Parameter to force update ephemeral OS disk for a virtual machine scale set VM. </summary>
        public bool? ForceUpdateOSDiskForEphemeral { get; set; }
    }
}
