// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class VirtualMachineScaleSetUpgradeModeExtensions
    {
        public static string ToSerialString(this VirtualMachineScaleSetUpgradeMode value) => value switch
        {
            VirtualMachineScaleSetUpgradeMode.Automatic => "Automatic",
            VirtualMachineScaleSetUpgradeMode.Manual => "Manual",
            VirtualMachineScaleSetUpgradeMode.Rolling => "Rolling",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown VirtualMachineScaleSetUpgradeMode value.")
        };

        public static VirtualMachineScaleSetUpgradeMode ToVirtualMachineScaleSetUpgradeMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Automatic")) return VirtualMachineScaleSetUpgradeMode.Automatic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Manual")) return VirtualMachineScaleSetUpgradeMode.Manual;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Rolling")) return VirtualMachineScaleSetUpgradeMode.Rolling;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown VirtualMachineScaleSetUpgradeMode value.");
        }
    }
}
