// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The VirtualMachineScaleSetGetExpand. </summary>
    public readonly partial struct VirtualMachineScaleSetGetExpand : IEquatable<VirtualMachineScaleSetGetExpand>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineScaleSetGetExpand"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachineScaleSetGetExpand(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserDataValue = "userData";

        /// <summary> userData. </summary>
        public static VirtualMachineScaleSetGetExpand UserData { get; } = new VirtualMachineScaleSetGetExpand(UserDataValue);
        /// <summary> Determines if two <see cref="VirtualMachineScaleSetGetExpand"/> values are the same. </summary>
        public static bool operator ==(VirtualMachineScaleSetGetExpand left, VirtualMachineScaleSetGetExpand right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachineScaleSetGetExpand"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachineScaleSetGetExpand left, VirtualMachineScaleSetGetExpand right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachineScaleSetGetExpand"/>. </summary>
        public static implicit operator VirtualMachineScaleSetGetExpand(string value) => new VirtualMachineScaleSetGetExpand(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachineScaleSetGetExpand other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachineScaleSetGetExpand other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
