// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Describes the script sources for run command. Use only one of script, scriptUri, commandId. </summary>
    public partial class VirtualMachineRunCommandScriptSource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineRunCommandScriptSource"/>. </summary>
        public VirtualMachineRunCommandScriptSource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualMachineRunCommandScriptSource"/>. </summary>
        /// <param name="script"> Specifies the script content to be executed on the VM. </param>
        /// <param name="scriptUri"> Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI. </param>
        /// <param name="commandId"> Specifies a commandId of predefined built-in script. </param>
        /// <param name="scriptUriManagedIdentity"> User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualMachineRunCommandScriptSource(string script, Uri scriptUri, string commandId, RunCommandManagedIdentity scriptUriManagedIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Script = script;
            ScriptUri = scriptUri;
            CommandId = commandId;
            ScriptUriManagedIdentity = scriptUriManagedIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the script content to be executed on the VM. </summary>
        public string Script { get; set; }
        /// <summary> Specifies the script download location. It can be either SAS URI of an Azure storage blob with read access or public URI. </summary>
        public Uri ScriptUri { get; set; }
        /// <summary> Specifies a commandId of predefined built-in script. </summary>
        public string CommandId { get; set; }
        /// <summary> User-assigned managed identity that has access to scriptUri in case of Azure storage blob. Use an empty object in case of system-assigned identity. Make sure the Azure storage blob exists, and managed identity has been given access to blob's container with 'Storage Blob Data Reader' role assignment. In case of user-assigned identity, make sure you add it under VM's identity. For more info on managed identity and Run Command, refer https://aka.ms/ManagedIdentity and https://aka.ms/RunCommandManaged. </summary>
        public RunCommandManagedIdentity ScriptUriManagedIdentity { get; set; }
    }
}
