// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The parameters of a managed disk. </summary>
    public partial class VirtualMachineManagedDisk : ComputeWriteableSubResourceData
    {
        /// <summary> Initializes a new instance of <see cref="VirtualMachineManagedDisk"/>. </summary>
        public VirtualMachineManagedDisk()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VirtualMachineManagedDisk"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="storageAccountType"> Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. </param>
        /// <param name="diskEncryptionSet"> Specifies the customer managed disk encryption set resource id for the managed disk. </param>
        /// <param name="securityProfile"> Specifies the security profile for the managed disk. </param>
        internal VirtualMachineManagedDisk(ResourceIdentifier id, IDictionary<string, BinaryData> serializedAdditionalRawData, StorageAccountType? storageAccountType, WritableSubResource diskEncryptionSet, VirtualMachineDiskSecurityProfile securityProfile) : base(id, serializedAdditionalRawData)
        {
            StorageAccountType = storageAccountType;
            DiskEncryptionSet = diskEncryptionSet;
            SecurityProfile = securityProfile;
        }

        /// <summary> Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. </summary>
        public StorageAccountType? StorageAccountType { get; set; }
        /// <summary> Specifies the customer managed disk encryption set resource id for the managed disk. </summary>
        internal WritableSubResource DiskEncryptionSet { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier DiskEncryptionSetId
        {
            get => DiskEncryptionSet is null ? default : DiskEncryptionSet.Id;
            set
            {
                if (DiskEncryptionSet is null)
                    DiskEncryptionSet = new WritableSubResource();
                DiskEncryptionSet.Id = value;
            }
        }

        /// <summary> Specifies the security profile for the managed disk. </summary>
        public VirtualMachineDiskSecurityProfile SecurityProfile { get; set; }
    }
}
