// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Compute.Models
{
    public partial class UserInitiatedRedeploy : IUtf8JsonSerializable, IJsonModel<UserInitiatedRedeploy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UserInitiatedRedeploy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UserInitiatedRedeploy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UserInitiatedRedeploy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UserInitiatedRedeploy)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AutomaticallyApprove))
            {
                writer.WritePropertyName("automaticallyApprove"u8);
                writer.WriteBooleanValue(AutomaticallyApprove.Value);
            }
            if (Optional.IsDefined(DummyProperty))
            {
                writer.WritePropertyName("dummyProperty"u8);
                writer.WriteStringValue(DummyProperty);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        UserInitiatedRedeploy IJsonModel<UserInitiatedRedeploy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UserInitiatedRedeploy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UserInitiatedRedeploy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUserInitiatedRedeploy(document.RootElement, options);
        }

        internal static UserInitiatedRedeploy DeserializeUserInitiatedRedeploy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? automaticallyApprove = default;
            string dummyProperty = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("automaticallyApprove"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    automaticallyApprove = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("dummyProperty"u8))
                {
                    dummyProperty = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UserInitiatedRedeploy(automaticallyApprove, dummyProperty, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<UserInitiatedRedeploy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UserInitiatedRedeploy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(UserInitiatedRedeploy)} does not support writing '{options.Format}' format.");
            }
        }

        UserInitiatedRedeploy IPersistableModel<UserInitiatedRedeploy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UserInitiatedRedeploy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUserInitiatedRedeploy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UserInitiatedRedeploy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UserInitiatedRedeploy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
