// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The name of the signature template that contains default UEFI keys. </summary>
    public readonly partial struct UefiSignatureTemplateName : IEquatable<UefiSignatureTemplateName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UefiSignatureTemplateName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UefiSignatureTemplateName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoSignatureTemplateValue = "NoSignatureTemplate";
        private const string MicrosoftUefiCertificateAuthorityTemplateValue = "MicrosoftUefiCertificateAuthorityTemplate";
        private const string MicrosoftWindowsTemplateValue = "MicrosoftWindowsTemplate";

        /// <summary> NoSignatureTemplate. </summary>
        public static UefiSignatureTemplateName NoSignatureTemplate { get; } = new UefiSignatureTemplateName(NoSignatureTemplateValue);
        /// <summary> MicrosoftUefiCertificateAuthorityTemplate. </summary>
        public static UefiSignatureTemplateName MicrosoftUefiCertificateAuthorityTemplate { get; } = new UefiSignatureTemplateName(MicrosoftUefiCertificateAuthorityTemplateValue);
        /// <summary> MicrosoftWindowsTemplate. </summary>
        public static UefiSignatureTemplateName MicrosoftWindowsTemplate { get; } = new UefiSignatureTemplateName(MicrosoftWindowsTemplateValue);
        /// <summary> Determines if two <see cref="UefiSignatureTemplateName"/> values are the same. </summary>
        public static bool operator ==(UefiSignatureTemplateName left, UefiSignatureTemplateName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UefiSignatureTemplateName"/> values are not the same. </summary>
        public static bool operator !=(UefiSignatureTemplateName left, UefiSignatureTemplateName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UefiSignatureTemplateName"/>. </summary>
        public static implicit operator UefiSignatureTemplateName(string value) => new UefiSignatureTemplateName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UefiSignatureTemplateName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UefiSignatureTemplateName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
