// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The type of key signature. </summary>
    public readonly partial struct UefiKeyType : IEquatable<UefiKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UefiKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UefiKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Sha256Value = "sha256";
        private const string X509Value = "x509";

        /// <summary> sha256. </summary>
        public static UefiKeyType Sha256 { get; } = new UefiKeyType(Sha256Value);
        /// <summary> x509. </summary>
        public static UefiKeyType X509 { get; } = new UefiKeyType(X509Value);
        /// <summary> Determines if two <see cref="UefiKeyType"/> values are the same. </summary>
        public static bool operator ==(UefiKeyType left, UefiKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UefiKeyType"/> values are not the same. </summary>
        public static bool operator !=(UefiKeyType left, UefiKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UefiKeyType"/>. </summary>
        public static implicit operator UefiKeyType(string value) => new UefiKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UefiKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UefiKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
