// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Additional UEFI key signatures that will be added to the image in addition to the signature templates. </summary>
    public partial class UefiKeySignatures
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UefiKeySignatures"/>. </summary>
        public UefiKeySignatures()
        {
            Kek = new ChangeTrackingList<UefiKey>();
            Db = new ChangeTrackingList<UefiKey>();
            Dbx = new ChangeTrackingList<UefiKey>();
        }

        /// <summary> Initializes a new instance of <see cref="UefiKeySignatures"/>. </summary>
        /// <param name="pk"> The Platform Key of this image version. </param>
        /// <param name="kek"> The Key Encryption Keys of this image version. </param>
        /// <param name="db"> The database of UEFI keys for this image version. </param>
        /// <param name="dbx"> The database of revoked UEFI keys for this image version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UefiKeySignatures(UefiKey pk, IList<UefiKey> kek, IList<UefiKey> db, IList<UefiKey> dbx, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Pk = pk;
            Kek = kek;
            Db = db;
            Dbx = dbx;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Platform Key of this image version. </summary>
        public UefiKey Pk { get; set; }
        /// <summary> The Key Encryption Keys of this image version. </summary>
        public IList<UefiKey> Kek { get; }
        /// <summary> The database of UEFI keys for this image version. </summary>
        public IList<UefiKey> Db { get; }
        /// <summary> The database of revoked UEFI keys for this image version. </summary>
        public IList<UefiKey> Dbx { get; }
    }
}
